//------------------------------------------------------------------------------
// File: client_cmdupgrades.cs
// This file contains the client side upgrade values
// Author: Matthew Rudge
//------------------------------------------------------------------------------

// Copy values so client can query these during updates
$CSUPCPY_VALUES[$CSUP_GUN]       = false;
$CSUPCPY_VALUES[$CSUP_AXE]       = false;
$CSUPCPY_VALUES[$CSUP_PICK]      = false;
$CSUPCPY_VALUES[$CSUP_BLDG]      = false;
$CSUPCPY_VALUES[$CSUP_CROPCORN]  = false;
$CSUPCPY_VALUES[$CSUP_CROPPUMP]  = false;
$CSUPCPY_VALUES[$CSUP_CROPFLWR]  = false; // OPTIONAL
$CSUPCPY_VALUES[$CSUP_ANIMPIG]   = false;
$CSUPCPY_VALUES[$CSUP_ANIMCOW]   = false;
$CSUPCPY_VALUES[$CSUP_ANIMSHEEP] = false; // OPTIONAL
$CSUPCPY_VALUES[$CSUP_TRACK]     = false;


////////////////////////////////////////////////////////////////////////////////
//! Tests whether an upgrade has been purchased or not
//! \param %upgrade Upgrade to check ($CSUP_GUN, $CSUP_AXE, etc.)
//! \retval bool True if the upgrade was purchased
////////////////////////////////////////////////////////////////////////////////
function csIsCmdUpgradePurchasedLocal(%upgrade)
{
   return $CSUPCPY_VALUES[%upgrade];
}

////////////////////////////////////////////////////////////////////////////////
//! Resets all the upgrades on the client (for query purposes)
////////////////////////////////////////////////////////////////////////////////
function clientCmdResetUpgrades()
{
   // Reset all upgrades to false
   for(%i = 0; %i < $CSUP_COUNT; %i++) {
      $CSUPCPY_VALUES[%i] = false;
   }
}

////////////////////////////////////////////////////////////////////////////////
//! Sets an upgrade on the client (for query purposes)
//! \param %upgrade Upgrade to set
//! \param %val Value for upgrade (true or false)
////////////////////////////////////////////////////////////////////////////////
function clientCmdSetCmdUpgrade(%upgrade, %val)
{
   $CSUPCPY_VALUES[%upgrade] = %val;
   
   // Send message to alert hud
   switch(%upgrade) {
      case $CSUP_AXE:
         %stringid = "id_upgradeactive_axe";
      case $CSUP_BLDG:
         %stringid = "id_upgradeactive_building";
      case $CSUP_GUN:
         %stringid = "id_upgradeactive_gun";
      case $CSUP_PICK:
         %stringid = "id_upgradeactive_pick";
      case $CSUP_TRACK:
         %stringid = "id_upgradeactive_track";
   }
   %string = slgGetUIString(%stringid);
   alertPushMsg(%string);
}

// End client_cmdupgrades.cs
